<?php
require_once '../includes/auth.php';
require_once '../includes/functions.php';

$adminAuth->requireLogin();

header('Content-Type: application/json');

try {
    // Get all products for analytics with real tracking data
    $query = "SELECT p.*, 
              (SELECT SUM(oi.quantity) FROM order_items oi JOIN orders o ON oi.order_id = o.id WHERE oi.product_id = p.id AND o.status != 'cancelled') as total_sold,
              (SELECT SUM(oi.total_price) FROM order_items oi JOIN orders o ON oi.order_id = o.id WHERE oi.product_id = p.id AND o.status != 'cancelled') as total_revenue,
              COALESCE(pas.views, 0) as total_views,
              COALESCE(pas.favorites, 0) as total_favorites,
              COALESCE(pas.add_to_cart, 0) as total_add_to_cart
              FROM products p 
              LEFT JOIN product_analytics_simple pas ON p.id = pas.product_id
              WHERE p.is_active = 1 
              ORDER BY total_sold DESC";
    $stmt = getDB()->query($query);
    $products = $stmt->fetchAll();

    // Get overall site analytics
    $totalVisitors = 0;
    $totalFavorites = 0;
    $totalAddToCarts = 0;

    try {
        // Count unique sessions as visitors
        $stmt = getDB()->query("SELECT COUNT(DISTINCT session_id) as visitors FROM site_analytics");
        $result = $stmt->fetch();
        $totalVisitors = $result['visitors'] ?? 0;
        
        // Total favorites
        $stmt = getDB()->query("SELECT COALESCE(SUM(favorites), 0) as favorites FROM product_analytics_simple");
        $result = $stmt->fetch();
        $totalFavorites = $result['favorites'] ?? 0;
        
        // Total add to cart
        $stmt = getDB()->query("SELECT COALESCE(SUM(add_to_cart), 0) as carts FROM product_analytics_simple");
        $result = $stmt->fetch();
        $totalAddToCarts = $result['carts'] ?? 0;
    } catch (Exception $e) {
        // Tables might not exist yet, will use fallback values
        error_log("Analytics table query error: " . $e->getMessage());
    }

    // Calculate performance metrics
    $stats = $adminFunctions->getDashboardStats();
    $totalOrders = $stats['total_orders'];
    $totalRevenue = $stats['total_revenue'];
    $totalCustomers = $stats['total_customers'];
    $totalProducts = $stats['total_products'];
    
    // Use ONLY real tracking data - no simulations
    $visitors = $totalVisitors;
    $favorites = $totalFavorites;
    $addToCarts = $totalAddToCarts;
    
    // Calculate real items sold from orders
    try {
        $stmt = getDB()->query("SELECT SUM(oi.quantity) as items FROM order_items oi JOIN orders o ON oi.order_id = o.id WHERE o.status != 'cancelled'");
        $result = $stmt->fetch();
        $itemsSold = $result['items'] ?? 0;
    } catch (Exception $e) {
        $itemsSold = 0;
    }

    echo json_encode([
        'success' => true,
        'data' => [
            'products' => $products,
            'stats' => [
                'total_orders' => $totalOrders,
                'total_revenue' => $totalRevenue,
                'total_customers' => $totalCustomers,
                'total_products' => $totalProducts,
                'visitors' => $visitors,
                'favorites' => $favorites,
                'add_to_carts' => $addToCarts,
                'items_sold' => $itemsSold
            ]
        ]
    ]);

} catch (Exception $e) {
    error_log("Analytics refresh error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching analytics data'
    ]);
}
?>
