<?php
require_once '../includes/auth.php';
require_once '../../models/FirebaseNotification.php';

$adminAuth->requireLogin();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$action = $_POST['action'] ?? '';
$firebaseNotification = new FirebaseNotification();
$adminName = $adminAuth->getAdminName();

try {
    switch ($action) {
        case 'send_to_all':
            $title = trim($_POST['title'] ?? '');
            $body = trim($_POST['body'] ?? '');
            
            if (empty($title) || empty($body)) {
                throw new Exception('Title and body are required');
            }
            
            $result = $firebaseNotification->sendNotificationToAll($title, $body, $adminName);
            echo json_encode($result);
            break;
            
        case 'send_to_user':
            $title = trim($_POST['title'] ?? '');
            $body = trim($_POST['body'] ?? '');
            $userId = intval($_POST['user_id'] ?? 0);
            
            if (empty($title) || empty($body) || $userId <= 0) {
                throw new Exception('Title, body, and valid user ID are required');
            }
            
            $result = $firebaseNotification->sendNotificationToUser($title, $body, $userId, $adminName);
            echo json_encode($result);
            break;
            
        case 'get_history':
            $page = intval($_POST['page'] ?? 1);
            $limit = 20;
            $offset = ($page - 1) * $limit;
            
            $history = $firebaseNotification->getNotificationHistory($limit, $offset);
            $total = $firebaseNotification->getTotalNotificationCount();
            
            echo json_encode([
                'success' => true,
                'data' => $history,
                'pagination' => [
                    'current_page' => $page,
                    'total_pages' => ceil($total / $limit),
                    'total_records' => $total,
                    'has_more' => $offset + $limit < $total
                ]
            ]);
            break;
            
        case 'get_stats':
            $stats = $firebaseNotification->getNotificationStats();
            echo json_encode(['success' => true, 'data' => $stats]);
            break;
            
        case 'get_users':
            $users = $firebaseNotification->getAllUsers();
            echo json_encode(['success' => true, 'data' => $users]);
            break;
            
        case 'test_connection':
            $result = $firebaseNotification->testConnection();
            echo json_encode($result);
            break;
            
        default:
            throw new Exception('Invalid action');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>