<?php
require_once '../includes/auth.php';
require_once '../../models/FirebaseNotification.php';

header('Content-Type: application/json');

$adminAuth->requireLogin();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$userId = $_POST['user_id'] ?? null;
$userName = $_POST['user_name'] ?? 'there';
$productName = $_POST['product_name'] ?? 'your cart items';

if (!$userId) {
    echo json_encode(['success' => false, 'message' => 'User ID is required']);
    exit;
}

try {
    $notificationModel = new FirebaseNotification();
    
    // Create personalized message
    $title = "Complete Your Purchase! 🛍️";
    $body = "Hey {$userName}! We see you added {$productName} to your cart. Complete your checkout now and enjoy your favorite perfume! 💝";
    
    // Get admin name
    $adminName = $adminAuth->getAdminName();
    
    // Send notification to specific user
    $result = $notificationModel->sendNotificationToUser($title, $body, $userId, $adminName);
    
    if ($result['success']) {
        echo json_encode([
            'success' => true,
            'message' => "Reminder sent successfully to {$userName}!",
            'details' => $result['message']
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Failed to send reminder: ' . $result['message']
        ]);
    }
    
} catch (Exception $e) {
    error_log("Cart reminder error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'An error occurred: ' . $e->getMessage()
    ]);
}
?>

