<?php
require_once 'includes/auth.php';
require_once 'includes/functions.php';

$adminAuth->requireLogin();

$stats = $adminFunctions->getDashboardStats();
$deliveredStats = $adminFunctions->getDeliveredStats();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Business Overview - Perfume Store</title>
    <link rel="stylesheet" href="assets/css/admin.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <img src="../images/LOGO.png" alt="Logo" class="sidebar-logo">
            <h3>Admin Panel</h3>
        </div>
        
        <nav class="sidebar-nav">
            <a href="index.php" class="nav-item active">
                <i class="fas fa-th-large"></i>
                <span>Overview</span>
            </a>
            <a href="pages/products.php" class="nav-item">
                <i class="fas fa-box"></i>
                <span>Products</span>
            </a>
            <a href="pages/orders.php" class="nav-item">
                <i class="fas fa-shopping-cart"></i>
                <span>Orders</span>
            </a>
            <a href="pages/delivered.php" class="nav-item">
                <i class="fas fa-check-circle"></i>
                <span>Delivered</span>
            </a>
            <a href="pages/customers.php" class="nav-item">
                <i class="fas fa-users"></i>
                <span>Customers</span>
            </a>
            <a href="pages/feedback.php" class="nav-item">
                <i class="fas fa-comments"></i>
                <span>Feedback</span>
            </a>
            <a href="pages/shipping.php" class="nav-item">
                <i class="fas fa-shipping-fast"></i>
                <span>Shipping</span>
            </a>
            <a href="pages/banners.php" class="nav-item">
                <i class="fas fa-image"></i>
                <span>Banners</span>
            </a>
            <a href="pages/presets.php" class="nav-item">
                <i class="fas fa-cogs"></i>
                <span>Field Presets</span>
            </a>
            <a href="pages/vouchers.php" class="nav-item">
                <i class="fas fa-ticket-alt"></i>
                <span>Voucher Management</span>
            </a>
            <a href="pages/notifications.php" class="nav-item">
                <i class="fas fa-bell"></i>
                <span>Push Notifications</span>
            </a>
            <a href="pages/analytics.php" class="nav-item">
                <i class="fas fa-chart-bar"></i>
                <span>Analytics</span>
            </a>
            <a href="pages/settings.php" class="nav-item">
                <i class="fas fa-cog"></i>
                <span>Settings</span>
            </a>
        </nav>
        
        <div class="sidebar-footer">
            <div class="user-info">
                <i class="fas fa-user-circle"></i>
                <span><?php echo htmlspecialchars($adminAuth->getAdminName()); ?></span>
            </div>
            <a href="logout.php" class="logout-btn">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Header -->
        <header class="header">
            <div class="header-left">
                <button class="sidebar-toggle">
                    <i class="fas fa-bars"></i>
                </button>
                <h1>Business Overview</h1>
            </div>
            <div class="header-right">
                <div class="header-actions">
                    <a href="../index.php" target="_blank" class="btn btn-outline">
                        <i class="fas fa-external-link-alt"></i>
                        View Store
                    </a>
                </div>
            </div>
        </header>

        <!-- Overview Content -->
        <div class="dashboard-content" style="padding: 25px; background: #f5f5f5;">
            
            <!-- Core Data Section -->
            <div style="margin-bottom: 30px;">
                <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 20px;">
                    <h2 style="font-size: 22px; font-weight: 600; color: #1f1f1f; margin: 0;">Core data</h2>
                    <div style="display: flex; gap: 10px;">
                        <button style="padding: 8px 16px; background: white; border: 1px solid #ddd; border-radius: 6px; cursor: pointer; font-size: 14px;">
                            <i class="fas fa-chart-bar"></i> Compare
                        </button>
                        <button style="padding: 8px 16px; background: white; border: 1px solid #ddd; border-radius: 6px; cursor: pointer; font-size: 14px;">
                            <i class="fas fa-download"></i> Export
                        </button>
                    </div>
                </div>

                <?php
                // Calculate metrics
                $avgOrderValue = $stats['total_orders'] > 0 ? $stats['total_revenue'] / $stats['total_orders'] : 0;
                $deliveryRate = $stats['total_orders'] > 0 ? ($deliveredStats['total_delivered'] / $stats['total_orders']) * 100 : 0;
                $pendingRate = $stats['total_orders'] > 0 ? ($stats['pending_orders'] / $stats['total_orders']) * 100 : 0;
                
                // Simulate trend data (in real app, fetch from previous period)
                $trends = [
                    'orders' => rand(-10, 20) / 10,
                    'revenue' => rand(-10, 25) / 10,
                    'customers' => rand(-5, 15) / 10,
                    'products' => rand(0, 10) / 10,
                    'avgOrder' => rand(-8, 18) / 10,
                    'delivery' => rand(-3, 12) / 10
                ];
                ?>

                <!-- Metrics Grid -->
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)); gap: 16px;">
                    
                    <!-- Total Orders -->
                    <div style="background: white; border-radius: 8px; padding: 20px; border: 1px solid #e8e8e8;">
                        <div style="display: flex; align-items: center; gap: 6px; margin-bottom: 12px;">
                            <span style="font-size: 14px; color: #666;">Total Orders</span>
                            <i class="fas fa-info-circle" style="font-size: 12px; color: #999;"></i>
                        </div>
                        <div style="font-size: 32px; font-weight: 600; color: #1f1f1f; margin-bottom: 8px;">
                            <?php echo number_format($stats['total_orders']); ?>
                        </div>
                        <div style="font-size: 13px; color: <?php echo $trends['orders'] >= 0 ? '#16a34a' : '#dc2626'; ?>;">
                            <i class="fas fa-arrow-<?php echo $trends['orders'] >= 0 ? 'up' : 'down'; ?>"></i>
                            <?php echo abs($trends['orders']); ?>% vs last 7 days
                        </div>
                    </div>

                    <!-- Total Revenue -->
                    <div style="background: white; border-radius: 8px; padding: 20px; border: 1px solid #e8e8e8;">
                        <div style="display: flex; align-items: center; gap: 6px; margin-bottom: 12px;">
                            <span style="font-size: 14px; color: #666;">Total Revenue</span>
                            <i class="fas fa-info-circle" style="font-size: 12px; color: #999;"></i>
                        </div>
                        <div style="font-size: 32px; font-weight: 600; color: #1f1f1f; margin-bottom: 8px;">
                            RM <?php echo number_format($stats['total_revenue'], 2); ?>
                        </div>
                        <div style="font-size: 13px; color: <?php echo $trends['revenue'] >= 0 ? '#16a34a' : '#dc2626'; ?>;">
                            <i class="fas fa-arrow-<?php echo $trends['revenue'] >= 0 ? 'up' : 'down'; ?>"></i>
                            <?php echo abs($trends['revenue']); ?>% vs last 7 days
                        </div>
                    </div>

                    <!-- Average Order Value -->
                    <div style="background: white; border-radius: 8px; padding: 20px; border: 1px solid #e8e8e8;">
                        <div style="display: flex; align-items: center; gap: 6px; margin-bottom: 12px;">
                            <span style="font-size: 14px; color: #666;">Average Order Value</span>
                            <i class="fas fa-info-circle" style="font-size: 12px; color: #999;"></i>
                        </div>
                        <div style="font-size: 32px; font-weight: 600; color: #1f1f1f; margin-bottom: 8px;">
                            RM <?php echo number_format($avgOrderValue, 2); ?>
                        </div>
                        <div style="font-size: 13px; color: <?php echo $trends['avgOrder'] >= 0 ? '#16a34a' : '#dc2626'; ?>;">
                            <i class="fas fa-arrow-<?php echo $trends['avgOrder'] >= 0 ? 'up' : 'down'; ?>"></i>
                            <?php echo abs($trends['avgOrder']); ?>% vs last 7 days
                        </div>
                    </div>

                    <!-- Total Customers -->
                    <div style="background: white; border-radius: 8px; padding: 20px; border: 1px solid #e8e8e8;">
                        <div style="display: flex; align-items: center; gap: 6px; margin-bottom: 12px;">
                            <span style="font-size: 14px; color: #666;">Total Customers</span>
                            <i class="fas fa-info-circle" style="font-size: 12px; color: #999;"></i>
                        </div>
                        <div style="font-size: 32px; font-weight: 600; color: #1f1f1f; margin-bottom: 8px;">
                            <?php echo number_format($stats['total_customers']); ?>
                        </div>
                        <div style="font-size: 13px; color: <?php echo $trends['customers'] >= 0 ? '#16a34a' : '#dc2626'; ?>;">
                            <i class="fas fa-arrow-<?php echo $trends['customers'] >= 0 ? 'up' : 'down'; ?>"></i>
                            <?php echo abs($trends['customers']); ?>% vs last 7 days
                        </div>
                    </div>

                    <!-- Delivery Success Rate -->
                    <div style="background: white; border-radius: 8px; padding: 20px; border: 1px solid #e8e8e8;">
                        <div style="display: flex; align-items: center; gap: 6px; margin-bottom: 12px;">
                            <span style="font-size: 14px; color: #666;">Delivery Success Rate</span>
                            <i class="fas fa-info-circle" style="font-size: 12px; color: #999;"></i>
                        </div>
                        <div style="font-size: 32px; font-weight: 600; color: #1f1f1f; margin-bottom: 8px;">
                            <?php echo number_format($deliveryRate, 2); ?>%
                        </div>
                        <div style="font-size: 13px; color: <?php echo $trends['delivery'] >= 0 ? '#16a34a' : '#dc2626'; ?>;">
                            <i class="fas fa-arrow-<?php echo $trends['delivery'] >= 0 ? 'up' : 'down'; ?>"></i>
                            <?php echo abs($trends['delivery']); ?>% vs last 7 days
                        </div>
                    </div>

                    <!-- Active Products -->
                    <div style="background: white; border-radius: 8px; padding: 20px; border: 1px solid #e8e8e8;">
                        <div style="display: flex; align-items: center; gap: 6px; margin-bottom: 12px;">
                            <span style="font-size: 14px; color: #666;">Active Products</span>
                            <i class="fas fa-info-circle" style="font-size: 12px; color: #999;"></i>
                        </div>
                        <div style="font-size: 32px; font-weight: 600; color: #1f1f1f; margin-bottom: 8px;">
                            <?php echo number_format($stats['total_products']); ?>
                        </div>
                        <div style="font-size: 13px; color: <?php echo $trends['products'] >= 0 ? '#16a34a' : '#dc2626'; ?>;">
                            <i class="fas fa-arrow-<?php echo $trends['products'] >= 0 ? 'up' : 'down'; ?>"></i>
                            <?php echo abs($trends['products']); ?>% vs last 7 days
                        </div>
                    </div>

                    <!-- Pending Orders -->
                    <div style="background: white; border-radius: 8px; padding: 20px; border: 1px solid #e8e8e8;">
                        <div style="display: flex; align-items: center; gap: 6px; margin-bottom: 12px;">
                            <span style="font-size: 14px; color: #666;">Pending Orders</span>
                            <i class="fas fa-info-circle" style="font-size: 12px; color: #999;"></i>
                        </div>
                        <div style="font-size: 32px; font-weight: 600; color: #1f1f1f; margin-bottom: 8px;">
                            <?php echo number_format($stats['pending_orders']); ?>
                        </div>
                        <div style="font-size: 13px; color: #666;">
                            <?php echo number_format($pendingRate, 1); ?>% of total orders
                        </div>
                    </div>

                    <!-- Low Stock Items -->
                    <div style="background: white; border-radius: 8px; padding: 20px; border: 1px solid #e8e8e8;">
                        <div style="display: flex; align-items: center; gap: 6px; margin-bottom: 12px;">
                            <span style="font-size: 14px; color: #666;">Low Stock Items</span>
                            <i class="fas fa-info-circle" style="font-size: 12px; color: #999;"></i>
                        </div>
                        <div style="font-size: 32px; font-weight: 600; color: <?php echo $stats['low_stock'] > 0 ? '#dc2626' : '#1f1f1f'; ?>; margin-bottom: 8px;">
                            <?php echo number_format($stats['low_stock']); ?>
                        </div>
                        <div style="font-size: 13px; color: #666;">
                            <?php if($stats['low_stock'] > 0): ?>
                                <i class="fas fa-exclamation-triangle" style="color: #f59e0b;"></i> Requires attention
                            <?php else: ?>
                                <i class="fas fa-check-circle" style="color: #16a34a;"></i> All stock healthy
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Delivered Orders -->
                    <div style="background: white; border-radius: 8px; padding: 20px; border: 1px solid #e8e8e8;">
                        <div style="display: flex; align-items: center; gap: 6px; margin-bottom: 12px;">
                            <span style="font-size: 14px; color: #666;">Delivered Orders</span>
                            <i class="fas fa-info-circle" style="font-size: 12px; color: #999;"></i>
                        </div>
                        <div style="font-size: 32px; font-weight: 600; color: #1f1f1f; margin-bottom: 8px;">
                            <?php echo number_format($deliveredStats['total_delivered']); ?>
                        </div>
                        <div style="font-size: 13px; color: #16a34a;">
                            <i class="fas fa-check"></i> Successfully completed
                        </div>
                    </div>

                </div>
            </div>

            <!-- Quick Actions Section -->
            <div style="background: white; border-radius: 8px; padding: 25px; border: 1px solid #e8e8e8;">
                <h3 style="font-size: 18px; font-weight: 600; color: #1f1f1f; margin: 0 0 20px 0;">Quick Actions</h3>
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(180px, 1fr)); gap: 12px;">
                    <a href="pages/products.php" style="display: flex; flex-direction: column; align-items: center; padding: 20px; background: #f9fafb; border-radius: 8px; text-decoration: none; color: #1f1f1f; border: 1px solid #e8e8e8; transition: all 0.2s;">
                        <i class="fas fa-plus-circle" style="font-size: 28px; color: #667eea; margin-bottom: 10px;"></i>
                        <span style="font-weight: 500; font-size: 14px;">Add Product</span>
                    </a>
                    <a href="pages/orders.php" style="display: flex; flex-direction: column; align-items: center; padding: 20px; background: #f9fafb; border-radius: 8px; text-decoration: none; color: #1f1f1f; border: 1px solid #e8e8e8; transition: all 0.2s;">
                        <i class="fas fa-clipboard-list" style="font-size: 28px; color: #16a34a; margin-bottom: 10px;"></i>
                        <span style="font-weight: 500; font-size: 14px;">Manage Orders</span>
                    </a>
                    <a href="pages/customers.php" style="display: flex; flex-direction: column; align-items: center; padding: 20px; background: #f9fafb; border-radius: 8px; text-decoration: none; color: #1f1f1f; border: 1px solid #e8e8e8; transition: all 0.2s;">
                        <i class="fas fa-users" style="font-size: 28px; color: #0ea5e9; margin-bottom: 10px;"></i>
                        <span style="font-weight: 500; font-size: 14px;">Customers</span>
                    </a>
                    <a href="pages/analytics.php" style="display: flex; flex-direction: column; align-items: center; padding: 20px; background: #f9fafb; border-radius: 8px; text-decoration: none; color: #1f1f1f; border: 1px solid #e8e8e8; transition: all 0.2s;">
                        <i class="fas fa-chart-line" style="font-size: 28px; color: #f59e0b; margin-bottom: 10px;"></i>
                        <span style="font-weight: 500; font-size: 14px;">Analytics</span>
                    </a>
                    <a href="pages/vouchers.php" style="display: flex; flex-direction: column; align-items: center; padding: 20px; background: #f9fafb; border-radius: 8px; text-decoration: none; color: #1f1f1f; border: 1px solid #e8e8e8; transition: all 0.2s;">
                        <i class="fas fa-ticket-alt" style="font-size: 28px; color: #ec4899; margin-bottom: 10px;"></i>
                        <span style="font-weight: 500; font-size: 14px;">Vouchers</span>
                    </a>
                    <a href="pages/banners.php" style="display: flex; flex-direction: column; align-items: center; padding: 20px; background: #f9fafb; border-radius: 8px; text-decoration: none; color: #1f1f1f; border: 1px solid #e8e8e8; transition: all 0.2s;">
                        <i class="fas fa-image" style="font-size: 28px; color: #8b5cf6; margin-bottom: 10px;"></i>
                        <span style="font-weight: 500; font-size: 14px;">Banners</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/admin.js"></script>
</body>
</html>