<?php
require_once '../config/database.php';

echo "<h2>Database Connection Test</h2>";

try {
    $pdo = getDB();
    if ($pdo) {
        echo "<p style='color: green;'>✅ Database connection successful!</p>";
        
        // Test if preset table exists
        $stmt = $pdo->query("SHOW TABLES LIKE 'product_field_presets'");
        if ($stmt->rowCount() > 0) {
            echo "<p style='color: green;'>✅ product_field_presets table exists!</p>";
            
            // Test if table has data
            $stmt = $pdo->query("SELECT COUNT(*) as count FROM product_field_presets");
            $result = $stmt->fetch();
            echo "<p style='color: blue;'>📊 Presets in database: " . $result['count'] . "</p>";
        } else {
            echo "<p style='color: red;'>❌ product_field_presets table does not exist!</p>";
            echo "<p>You need to run the database schema first.</p>";
        }
    } else {
        echo "<p style='color: red;'>❌ Database connection failed!</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}
?>