<?php
session_start();
require_once '../models/Order.php';
require_once '../config/database.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] === 'guest') {
    echo json_encode(['success' => false, 'message' => 'Please login first']);
    exit();
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['order_id'])) {
    echo json_encode(['success' => false, 'message' => 'Order ID is required']);
    exit();
}

$order_id = (int)$input['order_id'];
$user_id = $_SESSION['user_id'];

try {
    $order = new Order();
    
    // Get order details to verify ownership
    $order_details = $order->getById($order_id);
    
    if (!$order_details) {
        echo json_encode(['success' => false, 'message' => 'Order not found']);
        exit();
    }
    
    if ($order_details['user_id'] != $user_id) {
        echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
        exit();
    }
    
    // Only allow cancellation of awaiting_payment orders
    if ($order_details['status'] !== 'awaiting_payment') {
        echo json_encode(['success' => false, 'message' => 'This order cannot be cancelled']);
        exit();
    }
    
    // Update order status to cancelled
    $result = $order->updateStatus($order_id, 'cancelled');
    
    if ($result) {
        echo json_encode(['success' => true, 'message' => 'Order cancelled successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to cancel order']);
    }
    
} catch (Exception $e) {
    error_log("Cancel order error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'An error occurred while cancelling the order']);
}
?>