<?php
session_start();
require_once '../includes/auth-check.php';
require_once '../config/database.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] === 'guest') {
    echo json_encode(['success' => false, 'message' => 'Please login to add favorites']);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

if (!$input || !isset($input['product_id']) || !isset($input['action'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid input']);
    exit;
}

$product_id = (int)$input['product_id'];
$action = $input['action']; // 'add' or 'remove'
$user_id = $_SESSION['user_id'];

try {
    $conn = getDB();
    
    if ($action === 'add') {
        // Check if already in favorites
        $stmt = $conn->prepare("SELECT COUNT(*) FROM wishlist WHERE user_id = ? AND product_id = ?");
        $stmt->execute([$user_id, $product_id]);
        $alreadyFavorite = $stmt->fetchColumn() > 0;
        
        if ($alreadyFavorite) {
            echo json_encode(['success' => false, 'message' => 'Already in favorites']);
        } else {
            // Add to favorites
            $stmt = $conn->prepare("INSERT INTO wishlist (user_id, product_id) VALUES (?, ?)");
            $result = $stmt->execute([$user_id, $product_id]);
            
            if ($result) {
                // Track analytics - increment favorite counter
                try {
                    $stmt = $conn->prepare("
                        INSERT INTO product_analytics_simple (product_id, favorites) 
                        VALUES (?, 1)
                        ON DUPLICATE KEY UPDATE 
                            favorites = favorites + 1,
                            last_favorited = NOW()
                    ");
                    $stmt->execute([$product_id]);
                } catch (Exception $e) {
                    // Don't fail the favorite action if analytics fails
                    error_log("Analytics tracking failed: " . $e->getMessage());
                }
                
                echo json_encode(['success' => true, 'message' => 'Added to favorites']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to add to favorites']);
            }
        }
    } elseif ($action === 'remove') {
        // Remove from favorites
        $stmt = $conn->prepare("DELETE FROM wishlist WHERE user_id = ? AND product_id = ?");
        $result = $stmt->execute([$user_id, $product_id]);
        
        if ($result) {
            echo json_encode(['success' => true, 'message' => 'Removed from favorites']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to remove from favorites']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid action']);
    }
    
} catch (Exception $e) {
    error_log("Error toggling favorite: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'An error occurred']);
}
?>