<?php
// Turn off error display to prevent HTML output
ini_set('display_errors', 0);
ini_set('log_errors', 1);

session_start();
require_once 'models/User.php';
require_once 'models/Cart.php';
require_once 'includes/remember-me.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'guest_login':
            $user = new User();
            $session_id = session_id();
            
            // Create guest user in database
            $guest_user_id = $user->createGuest($session_id);
            
            if ($guest_user_id) {
                $_SESSION['user_id'] = $guest_user_id;
                $_SESSION['user_email'] = 'guest_' . $session_id . '@temp.com';
                $_SESSION['user_name'] = 'Guest User';
                $_SESSION['is_guest'] = true;
                
                echo json_encode([
                    'success' => true,
                    'message' => 'Guest access granted'
                ]);
            } else {
                echo json_encode([
                    'success' => false,
                    'message' => 'Failed to create guest session'
                ]);
            }
            break;
            
        case 'logout':
            // Clear remember me token if exists
            clearRememberMe();
            
            // Clear all session data
            session_destroy();
            
            echo json_encode([
                'success' => true,
                'message' => 'Logged out successfully'
            ]);
            break;
            
        case 'add_to_cart':
            try {
                // Check if user is logged in
                if (!isset($_SESSION['user_id']) || empty($_SESSION['user_id'])) {
                    echo json_encode([
                        'success' => false, 
                        'message' => 'Please sign up to add items to cart',
                        'redirect' => 'signup.php'
                    ]);
                    break;
                }
                
                $cart = new Cart();
                $user_id = $_SESSION['user_id'];
                $session_id = session_id();
                
                $product_id = (int)$_POST['product_id'];
                $quantity = (int)$_POST['quantity'];
                $size = $_POST['size'] ?? null;
                $version = $_POST['version'] ?? null;
                $price = (float)$_POST['price'];
                
                // Debug logging (remove in production)
                error_log("Add to cart: user_id=$user_id, session_id=$session_id, product_id=$product_id, quantity=$quantity, size=$size, version=$version, price=$price");
                
                $cart_item_id = $cart->addItem($user_id, $session_id, $product_id, $quantity, $price, $size, $version);
                if ($cart_item_id) {
                    $cart_count = $cart->getCartCount($user_id, $session_id);
                    error_log("Successfully added to cart. Cart count: $cart_count, Cart item ID: $cart_item_id");
                    echo json_encode(['success' => true, 'cart_count' => $cart_count, 'cart_item_id' => $cart_item_id]);
                } else {
                    error_log("Failed to add item to cart");
                    echo json_encode(['success' => false, 'message' => 'Failed to add item to cart']);
                }
            } catch (Exception $e) {
                error_log("Error in add_to_cart: " . $e->getMessage());
                echo json_encode(['success' => false, 'message' => 'Server error: ' . $e->getMessage()]);
            }
            break;
            
        case 'update_cart':
            $cart = new Cart();
            $user_id = $_SESSION['user_id'] ?? null;
            $session_id = session_id();
            
            $cart_item_id = (int)$_POST['cart_item_id'];
            $quantity = (int)$_POST['quantity'];
            
            if ($cart->updateQuantity($cart_item_id, $quantity)) {
                $cart_count = $cart->getCartCount($user_id, $session_id);
                echo json_encode(['success' => true, 'cart_count' => $cart_count]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to update cart']);
            }
            break;
            
        case 'remove_from_cart':
            $cart = new Cart();
            $user_id = $_SESSION['user_id'] ?? null;
            $session_id = session_id();
            
            $cart_item_id = (int)$_POST['cart_item_id'];
            
            if ($cart->removeItem($cart_item_id)) {
                $cart_count = $cart->getCartCount($user_id, $session_id);
                echo json_encode(['success' => true, 'cart_count' => $cart_count]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to remove item from cart']);
            }
            break;
            
        case 'get_cart':
            try {
                $cart = new Cart();
                $user_id = $_SESSION['user_id'] ?? null;
                $session_id = session_id();
                
                $cart_items = $cart->getCartItems($user_id, $session_id);
                $cart_total = $cart->getCartTotal($user_id, $session_id);
                echo json_encode(['success' => true, 'items' => $cart_items, 'total' => $cart_total]);
            } catch (Exception $e) {
                error_log("Error in get_cart: " . $e->getMessage());
                echo json_encode(['success' => false, 'message' => 'Server error: ' . $e->getMessage()]);
            }
            break;
            
        case 'test_db':
            try {
                $cart = new Cart();
                echo json_encode(['success' => true, 'message' => 'Database connection working']);
            } catch (Exception $e) {
                echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
            }
            break;
            
        case 'check_auth':
            $logged_in = isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
            echo json_encode([
                'success' => true,
                'logged_in' => $logged_in,
                'user_id' => $_SESSION['user_id'] ?? null,
                'is_guest' => $_SESSION['is_guest'] ?? false
            ]);
            break;
            
        case 'check_registered_user':
            $logged_in = isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
            $is_guest = isset($_SESSION['is_guest']) && $_SESSION['is_guest'] === true;
            $is_registered = $logged_in && !$is_guest;
            
            echo json_encode([
                'success' => true,
                'is_registered' => $is_registered,
                'logged_in' => $logged_in,
                'is_guest' => $is_guest
            ]);
            break;
            
        default:
            echo json_encode([
                'success' => false,
                'message' => 'Invalid action'
            ]);
            break;
    }
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid request method'
    ]);
}
?>