<?php
require_once 'models/Product.php';

// Get all best seller products from database
$product = new Product();
$bestSellers = $product->getBestSellers(20); // Get more best sellers for the dedicated page
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Best Sellers - 2 Days Parfume</title>
    <link rel="stylesheet" href="styles.css">
    <link rel="stylesheet" href="products.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="script.js" defer></script>
</head>
<body class="product-catalog-page">
    <!-- Top Navigation -->
    <nav class="top-nav">
        <div class="nav-left">
            <i class="fas fa-bars" id="hamburger-menu"></i>
        </div>
        <div class="nav-center">
            <div class="logo">
                <img src="images/LOGO.png" alt="2 Days Parfume Logo" class="logo-img">
            </div>
        </div>
        <div class="nav-right">
            <div class="search-cart-container">
                <i class="fas fa-shopping-cart cart-icon" onclick="window.location.href='cart.php'">
                    <span class="cart-count" id="cart-count">0</span>
                </i>
            </div>
        </div>
    </nav>

    <!-- Mobile Menu Overlay -->
    <div class="mobile-menu-overlay" id="mobile-menu-overlay">
        <div class="mobile-menu" id="mobile-menu">
        <div class="mobile-menu-header">
            <div class="mobile-logo">
                <img src="images/LOGO.png" alt="2 Days Parfume Logo" class="mobile-logo-img">
            </div>
            <button class="mobile-menu-close" id="mobile-menu-close">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="mobile-menu-content">
            <ul class="mobile-menu-list">
                <li><a href="index.php" class="mobile-menu-item"><i class="fas fa-home"></i> Home</a></li>
                <li><a href="bestseller.php" class="mobile-menu-item"><i class="fas fa-star"></i> Best Sellers</a></li>
                <li><a href="product-catalog.php" class="mobile-menu-item"><i class="fas fa-box"></i> All Products</a></li>
                <li><a href="favorites.php" class="mobile-menu-item"><i class="fas fa-heart"></i> Favorites</a></li>
                <li><a href="cart.php" class="mobile-menu-item"><i class="fas fa-shopping-cart"></i> Cart</a></li>
                <li><a href="login.php" class="mobile-menu-item"><i class="fas fa-sign-in-alt"></i> Login</a></li>
                <li><a href="signup.php" class="mobile-menu-item"><i class="fas fa-user-plus"></i> Sign Up</a></li>
                <li><a href="#" class="mobile-menu-item"><i class="fas fa-cog"></i> Settings</a></li>
            </ul>
        </div>
        </div>
    </div>

    <!-- Main Content -->
    <main class="main-content">
        <!-- Page Header -->
        <div class="page-header">
            <h1>Best Sellers</h1>
            <p class="page-subtitle">The Most Popular & Loved Parfumes</p>
        </div>


        <!-- Results Header -->
        <div class="results-header">
            <div class="results-info">
                <span class="results-count"><?php echo count($bestSellers); ?> products found</span>
            </div>
        </div>

        <!-- Best Sellers Products Grid -->
        <section class="products-section">
            <div class="products-grid" id="products-grid">
                <?php foreach ($bestSellers as $product): ?>
                <?php include 'includes/product-card.php'; ?>
                <?php endforeach; ?>
            </div>
        </section>
    </main>

    <!-- Bottom Navigation -->
    <nav class="bottom-nav">
        <div class="nav-item" onclick="window.location.href='index.php'">
            <i class="fas fa-home"></i>
        </div>
        <div class="nav-item active" onclick="window.location.href='product-catalog.php'">
            <i class="fas fa-box"></i>
        </div>
        <div class="nav-item" onclick="window.location.href='cart.php'">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <div class="nav-item" onclick="checkRegisteredUserAndRedirect('royalty-rewards.php')">
            <i class="fas fa-crown"></i>
        </div>
    </nav>

    <script>
        function viewProduct(productId) {
            window.location.href = 'product-detail.php?id=' + productId;
        }

        // Load cart count on page load
        document.addEventListener('DOMContentLoaded', function() {
            const cart = JSON.parse(localStorage.getItem('cart') || '[]');
            const totalItems = cart.reduce((sum, item) => sum + item.qty, 0);
            document.querySelector('.cart-count').textContent = totalItems;
        });
    </script>
</body>
</html>