<?php
echo "<h2>Server Upload Limits Check</h2>";

echo "<h3>PHP Upload Configuration:</h3>";
echo "upload_max_filesize: " . ini_get('upload_max_filesize') . "<br>";
echo "post_max_size: " . ini_get('post_max_size') . "<br>";
echo "max_execution_time: " . ini_get('max_execution_time') . " seconds<br>";
echo "max_input_time: " . ini_get('max_input_time') . " seconds<br>";
echo "memory_limit: " . ini_get('memory_limit') . "<br>";

echo "<h3>File Upload Test:</h3>";
echo "Max file size for banner upload: 10MB<br>";
echo "Allowed file types: JPG, PNG, GIF, MP4, WebM, OGG, AVI, MOV<br>";

echo "<h3>Recommendations:</h3>";
$uploadMax = ini_get('upload_max_filesize');
$postMax = ini_get('post_max_size');

echo "Current server limits:<br>";
echo "- upload_max_filesize: " . $uploadMax . "<br>";
echo "- post_max_size: " . $postMax . "<br>";

if (strpos($uploadMax, 'M') !== false) {
    $uploadMB = (int)$uploadMax;
    if ($uploadMB < 10) {
        echo "<p style='color: red;'>⚠️ Server upload limit is lower than our 10MB limit. Videos may fail to upload.</p>";
        echo "<p>Consider using smaller video files or contact your hosting provider to increase upload limits.</p>";
    } else {
        echo "<p style='color: green;'>✅ Server upload limit is sufficient for 10MB files.</p>";
    }
}

echo "<p><a href='admin/pages/banners.php'>Go to Banner Management</a></p>";
?>