-- Add Google OAuth support to users table
-- Run this SQL script to add Google OAuth columns

USE perfume_store;

-- Add Google OAuth columns to users table
ALTER TABLE users 
ADD COLUMN google_id VARCHAR(191) UNIQUE NULL AFTER email,
ADD COLUMN email_verified BOOLEAN DEFAULT FALSE AFTER password;

-- Create index for Google ID for faster lookups
CREATE INDEX idx_users_google_id ON users(google_id);

-- Update existing users to have email_verified = TRUE (assuming they are verified)
UPDATE users SET email_verified = TRUE WHERE google_id IS NULL AND is_guest = FALSE;

-- Make password nullable for OAuth users
ALTER TABLE users MODIFY COLUMN password VARCHAR(255) NULL;