-- Add version system to products
-- First, add version field to products table
ALTER TABLE products ADD COLUMN version_type VARCHAR(50) AFTER brand;

-- Create version_variations table for version-size-price combinations
CREATE TABLE IF NOT EXISTS version_variations (
    id INT AUTO_INCREMENT PRIMARY KEY,
    product_id INT NOT NULL,
    version_type VARCHAR(50) NOT NULL,
    size VARCHAR(20) NOT NULL,
    price DECIMAL(10,2) NOT NULL,
    stock_quantity INT DEFAULT 0,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE,
    UNIQUE KEY unique_version_size (product_id, version_type, size)
);

-- Add indexes for better performance
CREATE INDEX idx_version_variations_product ON version_variations(product_id);
CREATE INDEX idx_version_variations_version ON version_variations(version_type);
CREATE INDEX idx_version_variations_active ON version_variations(is_active);