-- Shipping Fees Table
-- Run this script to create the shipping fees table

USE perfume_store;

-- Create shipping fees table (weight-based for EZ Parcel)
CREATE TABLE IF NOT EXISTS shipping_fees (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    description TEXT,
    fee_type ENUM('weight_based', 'free_shipping_threshold') NOT NULL DEFAULT 'weight_based',
    base_fee DECIMAL(10,2) NOT NULL DEFAULT 0.00,
    per_kg_fee DECIMAL(10,2) NOT NULL DEFAULT 0.00,
    min_weight DECIMAL(5,2) DEFAULT 0.00,
    max_weight DECIMAL(5,2) DEFAULT NULL,
    min_order_amount DECIMAL(10,2) DEFAULT 0.00,
    max_order_amount DECIMAL(10,2) DEFAULT NULL,
    delivery_days_min INT DEFAULT 1,
    delivery_days_max INT DEFAULT 3,
    is_active BOOLEAN DEFAULT TRUE,
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert EZ Parcel shipping configuration
INSERT IGNORE INTO shipping_fees (name, description, fee_type, base_fee, per_kg_fee, min_weight, max_weight, min_order_amount, delivery_days_min, delivery_days_max, is_active, sort_order) VALUES
('EZ Parcel Standard', 'Standard delivery via EZ Parcel (2-3 business days)', 'weight_based', 5.00, 2.50, 0.00, 10.00, 0.00, 2, 3, 1, 1),
('EZ Parcel Express', 'Express delivery via EZ Parcel (1-2 business days)', 'weight_based', 8.00, 3.50, 0.00, 10.00, 0.00, 1, 2, 1, 2),
('Free Shipping', 'Free delivery for orders above RM 150', 'free_shipping_threshold', 0.00, 0.00, 0.00, NULL, 150.00, 2, 4, 1, 3);

-- Create indexes for better performance (ignore errors if they already exist)
CREATE INDEX idx_shipping_fees_active ON shipping_fees(is_active);
CREATE INDEX idx_shipping_fees_sort ON shipping_fees(sort_order);
CREATE INDEX idx_shipping_fees_min_amount ON shipping_fees(min_order_amount);