<?php
session_start();
require_once 'config/google-oauth.php';
require_once 'models/User.php';

// Check if we have an authorization code
if (!isset($_GET['code'])) {
    // If there's an error, redirect to login with error message
    if (isset($_GET['error'])) {
        header('Location: login.php?error=oauth_cancelled');
        exit();
    }
    
    // No code and no error, redirect to login
    header('Location: login.php');
    exit();
}

try {
    // Exchange authorization code for access token
    $token_data = getGoogleAccessToken($_GET['code']);
    
    if (!$token_data || !isset($token_data['access_token'])) {
        throw new Exception('Failed to get access token from Google');
    }
    
    // Get user information from Google
    $google_user = getGoogleUserInfo($token_data['access_token']);
    
    if (!$google_user) {
        throw new Exception('Failed to get user information from Google');
    }
    
    // Check if user already exists before creating/updating
    $user = new User();
    $existing_user = $user->getByEmail($google_user['email']);
    $was_new_user = !$existing_user;
    
    // Create or update user in database
    $user_data = $user->createOrUpdateFromGoogle($google_user);
    
    if (!$user_data) {
        throw new Exception('Failed to create or update user in database');
    }
    
    // Set session variables
    $_SESSION['user_id'] = $user_data['id'];
    $_SESSION['user_email'] = $user_data['email'];
    $_SESSION['user_name'] = $user_data['first_name'] . ' ' . $user_data['last_name'];
    $_SESSION['oauth_provider'] = 'google';
    
    // Check if there's a redirect URL stored
    $redirect_url = 'index.php';
    if (isset($_SESSION['redirect_after_signup'])) {
        $redirect_url = $_SESSION['redirect_after_signup'];
        unset($_SESSION['redirect_after_signup']);
    }
    
    // Redirect based on whether it was login or signup
    if ($was_new_user) {
        if ($redirect_url !== 'index.php') {
            header('Location: ' . $redirect_url);
        } else {
            header('Location: index.php?signup=success');
        }
    } else {
        if ($redirect_url !== 'index.php') {
            header('Location: ' . $redirect_url);
        } else {
            header('Location: index.php?login=success');
        }
    }
    exit();
    
} catch (Exception $e) {
    // Log the error
    error_log('Google OAuth Error: ' . $e->getMessage());
    
    // Redirect to login with error message
    header('Location: login.php?error=oauth_failed');
    exit();
}
?>