<?php
/**
 * Authentication Check Functions
 * Handles authentication requirements for protected features
 */

function requireAuth() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    // Check if user is logged in (either registered user or guest)
    if (!isset($_SESSION['user_id']) || empty($_SESSION['user_id'])) {
        // Redirect to signup page
        header('Location: signup.php?redirect=' . urlencode($_SERVER['REQUEST_URI']));
        exit();
    }
}

function requireRegisteredUser() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    // Check if user is logged in and not a guest
    if (!isset($_SESSION['user_id']) || empty($_SESSION['user_id'])) {
        // Redirect to signup page
        header('Location: signup.php?redirect=' . urlencode($_SERVER['REQUEST_URI']));
        exit();
    }
    
    // Check if user is not a guest
    if (isset($_SESSION['is_guest']) && $_SESSION['is_guest'] === true) {
        // Redirect to signup page for guest users
        header('Location: signup.php?redirect=' . urlencode($_SERVER['REQUEST_URI']));
        exit();
    }
}

function isLoggedIn() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
}

function isGuest() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    return isset($_SESSION['is_guest']) && $_SESSION['is_guest'] === true;
}

function isRegisteredUser() {
    return isLoggedIn() && !isGuest();
}

function getUserId() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    return $_SESSION['user_id'] ?? null;
}

function getUserEmail() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    return $_SESSION['user_email'] ?? null;
}

function getUserName() {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    return $_SESSION['user_name'] ?? 'Guest';
}
?>