<?php
session_start();
require_once 'models/Product.php';
require_once 'includes/remember-me.php';

// Check for remember me token and auto-login
checkRememberMe();

// Get product data from database
$product = new Product();
$bestSellers = $product->getBestSellers(2);
$justArrived = $product->getNewArrivals(6);
$filterOptions = $product->getFilterOptions();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perfume Store</title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <?php include_once 'includes/appilix-sdk.php'; ?>
    <?php include_once 'includes/appilix-user-identity.php'; ?>
    <script src="script.js" defer></script>
</head>
<body>
    <!-- Top Navigation -->
    <nav class="top-nav">
        <div class="nav-left">
            <i class="fas fa-bars" id="hamburger-menu"></i>
        </div>
        <div class="nav-center">
            <div class="logo">
                <img src="images/LOGO.png" alt="2 Days Parfume Logo" class="logo-img">
            </div>
        </div>
        <div class="nav-right">
            <i class="far fa-user" onclick="window.location.href='profile.php'"></i>
        </div>
    </nav>

    <!-- Mobile Menu Overlay -->
    <div class="mobile-menu-overlay" id="mobile-menu-overlay">
        <div class="mobile-menu">
            <div class="mobile-menu-header">
                <div class="mobile-menu-logo">
                    <img src="images/LOGO.png" alt="2 Days Parfume Logo" class="mobile-logo-img">
                </div>
                <button class="mobile-menu-close" id="mobile-menu-close">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="mobile-menu-content">
                <ul class="mobile-menu-list">
                    <li><a href="index.php" class="mobile-menu-item"><i class="fas fa-home"></i> Home</a></li>
                    <li><a href="bestseller.php" class="mobile-menu-item"><i class="fas fa-star"></i> Best Sellers</a></li>
                    <li><a href="products.php" class="mobile-menu-item"><i class="fas fa-box"></i> All Products</a></li>
                    <li><a href="#" class="mobile-menu-item"><i class="fas fa-heart"></i> Favorites</a></li>
                    <li><a href="#" class="mobile-menu-item"><i class="fas fa-shopping-cart"></i> Cart</a></li>
                    <li><a href="login.php" class="mobile-menu-item"><i class="fas fa-sign-in-alt"></i> Login</a></li>
                    <li><a href="signup.php" class="mobile-menu-item"><i class="fas fa-user-plus"></i> Sign Up</a></li>
                    <li><a href="#" class="mobile-menu-item"><i class="fas fa-cog"></i> Settings</a></li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <main class="main-content">
        <!-- Promotional Banner Section -->
        <section class="banner-slider">
            <div class="banner-container" id="bannerContainer">
                <!-- Banners will be loaded dynamically here -->
                <div class="banner-loading">
                    <i class="fas fa-spinner fa-spin"></i>
                    <p>Loading banners...</p>
                </div>
            </div>
            
            <!-- Navigation Dots -->
            <div class="banner-dots" id="bannerDots">
                <!-- Dots will be generated dynamically -->
            </div>
            
            <!-- Navigation Arrows -->
            <button class="banner-prev" onclick="changeSlide(-1)">&#10094;</button>
            <button class="banner-next" onclick="changeSlide(1)">&#10095;</button>
        </section>

        <!-- Feature Icons Section -->
        <section class="feature-icons">
            <div class="feature-icon" onclick="window.location.href='bestseller.php'">
                <div class="feature-icon-circle">
                    <i class="fas fa-star"></i>
                </div>
                <span class="feature-icon-label">Best Sellers</span>
            </div>
            <div class="feature-icon" onclick="window.location.href='products.php'">
                <div class="feature-icon-circle">
                    <i class="fas fa-gift"></i>
                </div>
                <span class="feature-icon-label">New Arrivals</span>
            </div>
            <div class="feature-icon" onclick="checkAuthAndRedirect('favorites.php')">
                <div class="feature-icon-circle">
                    <i class="far fa-heart"></i>
                </div>
                <span class="feature-icon-label">Favorites</span>
            </div>
            <div class="feature-icon" onclick="window.location.href='products.php'">
                <div class="feature-icon-circle">
                    <i class="fas fa-tags"></i>
                </div>
                <span class="feature-icon-label">Sale</span>
            </div>
        </section>

        <!-- Best Sellers Section -->
        <section class="product-section new-arrivals-section">
            <div class="section-header">
                <div class="section-title">
                    <h2>Best Sellers</h2>
                    <p class="section-subtitle">The Best Parfume Ever</p>
                </div>
                <button class="see-all-btn" onclick="window.location.href='product-catalog.php?category=bestseller'">see all ></button>
            </div>
            
            <div class="new-arrivals-grid">
                <?php foreach ($bestSellers as $index => $product): ?>
                <?php include 'includes/product-card.php'; ?>
                <?php endforeach; ?>
            </div>
            
        </section>

        <!-- Perfume Finder Section -->
        <section class="perfume-finder-section">
            <div class="section-header">
                <div class="section-title">
                    <h2>Find Your Perfect Scent</h2>
                    <p class="section-subtitle">Filter perfumes by your preferences</p>
                </div>
                <button id="apply-filters" class="apply-filters-btn">
                    <i class="fas fa-search"></i>
                </button>
            </div>
            
            <div class="filter-container">
                <div class="filter-grid">
                    <!-- Scent Filter -->
                    <div class="filter-group">
                        <label for="scent-filter" class="filter-label">
                            <i class="fas fa-leaf"></i>
                            Scent Type
                        </label>
                        <select id="scent-filter" class="filter-select">
                            <option value="">All Scents</option>
                            <?php if (isset($filterOptions['scent'])): ?>
                                <?php foreach ($filterOptions['scent'] as $scent): ?>
                                    <option value="<?php echo htmlspecialchars($scent); ?>"><?php echo htmlspecialchars($scent); ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>

                    <!-- Notes Filter -->
                    <div class="filter-group">
                        <label for="notes-filter" class="filter-label">
                            <i class="fas fa-music"></i>
                            Notes
                        </label>
                        <select id="notes-filter" class="filter-select">
                            <option value="">All Notes</option>
                            <?php if (isset($filterOptions['notes'])): ?>
                                <?php foreach ($filterOptions['notes'] as $note): ?>
                                    <option value="<?php echo htmlspecialchars($note); ?>"><?php echo htmlspecialchars($note); ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>

                    <!-- Season Filter -->
                    <div class="filter-group">
                        <label for="season-filter" class="filter-label">
                            <i class="fas fa-calendar-alt"></i>
                            Season
                        </label>
                        <select id="season-filter" class="filter-select">
                            <option value="">All Seasons</option>
                            <?php if (isset($filterOptions['season'])): ?>
                                <?php foreach ($filterOptions['season'] as $season): ?>
                                    <option value="<?php echo htmlspecialchars($season); ?>"><?php echo htmlspecialchars($season); ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>

                    <!-- Recommendation Filter -->
                    <div class="filter-group">
                        <label for="recommendation-filter" class="filter-label">
                            <i class="fas fa-star"></i>
                            Occasion
                        </label>
                        <select id="recommendation-filter" class="filter-select">
                            <option value="">All Occasions</option>
                            <?php if (isset($filterOptions['recommendation'])): ?>
                                <?php foreach ($filterOptions['recommendation'] as $recommendation): ?>
                                    <option value="<?php echo htmlspecialchars($recommendation); ?>"><?php echo htmlspecialchars($recommendation); ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>

            </div>

            <!-- Filter Results -->
            <div id="filter-results" class="filter-results" style="display: none;">
                <div class="results-header">
                    <h3 id="results-count">Found 0 perfumes</h3>
                    <button id="close-results" class="close-results-btn">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div id="filtered-products" class="new-arrivals-grid">
                    <!-- Filtered products will be loaded here -->
                </div>
            </div>
        </section>

        <!-- Just Arrived Section -->
        <section class="product-section new-arrivals-section">
            <div class="section-header">
                <div class="section-title">
                    <h2>Just Arrived</h2>
                    <p class="section-subtitle">Recently Arrived Parfums</p>
                </div>
                <button class="see-all-btn" onclick="window.location.href='product-catalog.php?category=new'">see all ></button>
            </div>
            
            <div class="new-arrivals-grid">
                <?php foreach ($justArrived as $index => $product): ?>
                <?php include 'includes/product-card.php'; ?>
                <?php endforeach; ?>
            </div>
            
            <!-- View More Button -->
            <div class="view-more-container">
                <button class="view-more-btn" onclick="window.location.href='product-catalog.php?category=new'">
                    View more
                </button>
            </div>
        </section>
    </main>

    <!-- Bottom Navigation -->
    <nav class="bottom-nav">
        <div class="nav-item active">
            <i class="fas fa-home"></i>
        </div>
        <div class="nav-item" onclick="window.location.href='products.php'">
            <i class="fas fa-box"></i>
        </div>
        <div class="nav-item" onclick="checkAuthAndRedirect('cart.php')">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <div class="nav-item" onclick="checkRegisteredUserAndRedirect('royalty-rewards.php')">
            <i class="fas fa-crown"></i>
        </div>
    </nav>

    <script>
        // Perfume Filter Functionality
        document.addEventListener('DOMContentLoaded', function() {
            const applyFiltersBtn = document.getElementById('apply-filters');
            const closeResultsBtn = document.getElementById('close-results');
            const filterResults = document.getElementById('filter-results');
            const filteredProducts = document.getElementById('filtered-products');
            const resultsCount = document.getElementById('results-count');

            // Apply filters
            applyFiltersBtn.addEventListener('click', function() {
                const filters = {
                    scent: document.getElementById('scent-filter').value,
                    notes: document.getElementById('notes-filter').value,
                    season: document.getElementById('season-filter').value,
                    recommendation: document.getElementById('recommendation-filter').value
                };

                // Show loading state
                applyFiltersBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
                applyFiltersBtn.disabled = true;

                // Make AJAX request
                fetch('ajax/filter_products.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(filters)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        filteredProducts.innerHTML = data.html;
                        resultsCount.textContent = `Found ${data.count} perfume${data.count !== 1 ? 's' : ''}`;
                        filterResults.style.display = 'block';
                        filterResults.scrollIntoView({ behavior: 'smooth' });
                    } else {
                        alert('Error filtering products: ' + (data.error || 'Unknown error'));
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error filtering products. Please try again.');
                })
                .finally(() => {
                    applyFiltersBtn.innerHTML = '<i class="fas fa-search"></i>';
                    applyFiltersBtn.disabled = false;
                });
            });

            // Clear filters function (can be called programmatically)
            function clearAllFilters() {
                document.getElementById('scent-filter').value = '';
                document.getElementById('notes-filter').value = '';
                document.getElementById('season-filter').value = '';
                document.getElementById('recommendation-filter').value = '';
                filterResults.style.display = 'none';
            }

            // Close results
            closeResultsBtn.addEventListener('click', function() {
                filterResults.style.display = 'none';
            });
        });
    </script>

    <!-- Banner Modal -->
    <div id="bannerModal" class="banner-modal">
        <div class="banner-modal-content">
            <span class="banner-modal-close">&times;</span>
            <img id="modalImage" src="" alt="Banner" style="display: none;">
            <video id="modalVideo" src="" controls autoplay loop muted style="display: none;"></video>
        </div>
    </div>

    <!-- Analytics Tracking Script -->
    <script src="js/analytics-tracking.js"></script>
</body>
</html>