<?php
session_start();
require_once 'models/User.php';
require_once 'includes/remember-me.php';

// Check for remember me token and auto-login
checkRememberMe();

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] === 'guest') {
    header('Location: login.php');
    exit();
}

// Get user data
$user = new User();
$user_data = $user->getById($_SESSION['user_id']);

if (!$user_data) {
    header('Location: login.php');
    exit();
}

$error_message = '';
$success_message = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email_notifications = isset($_POST['email_notifications']) ? 1 : 0;
    $sms_notifications = isset($_POST['sms_notifications']) ? 1 : 0;
    $push_notifications = isset($_POST['push_notifications']) ? 1 : 0;
    $order_updates = isset($_POST['order_updates']) ? 1 : 0;
    $promotional_emails = isset($_POST['promotional_emails']) ? 1 : 0;
    $newsletter = isset($_POST['newsletter']) ? 1 : 0;
    
    // For now, we'll store these in session or a simple way
    // In a real application, you'd store these in a user_preferences table
    $_SESSION['notification_preferences'] = [
        'email_notifications' => $email_notifications,
        'sms_notifications' => $sms_notifications,
        'push_notifications' => $push_notifications,
        'order_updates' => $order_updates,
        'promotional_emails' => $promotional_emails,
        'newsletter' => $newsletter
    ];
    
    $success_message = 'Notification preferences updated successfully!';
}

// Get current preferences (default values if not set)
$preferences = $_SESSION['notification_preferences'] ?? [
    'email_notifications' => 1,
    'sms_notifications' => 0,
    'push_notifications' => 1,
    'order_updates' => 1,
    'promotional_emails' => 0,
    'newsletter' => 0
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notification Settings - 2 Days Parfume</title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="script.js" defer></script>
    <style>
        .notification-settings-container {
            min-height: 100vh;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            padding-bottom: 100px;
        }

        .notification-settings-header {
            background: linear-gradient(135deg, #1A4D2A 0%, #2d5a3d 50%, #1A4D2A 100%);
            padding: 20px 20px 30px 20px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .notification-settings-header::before {
            content: '';
            position: absolute;
            bottom: -20px;
            left: 0;
            right: 0;
            height: 40px;
            background: linear-gradient(135deg, #1A4D2A 0%, #2d5a3d 50%, #1A4D2A 100%);
            border-radius: 50% 50% 0 0 / 100% 100% 0 0;
        }

        .notification-settings-title {
            color: #D4AF37;
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .notification-settings-subtitle {
            color: #F4D03F;
            font-size: 14px;
        }

        .notification-settings-content {
            padding: 30px 20px;
            margin-top: -20px;
            position: relative;
            z-index: 2;
        }

        .settings-container {
            background: white;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .settings-section {
            margin-bottom: 30px;
        }

        .settings-section:last-child {
            margin-bottom: 0;
        }

        .section-title {
            font-size: 18px;
            font-weight: bold;
            color: #1A4D2A;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .setting-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 15px 0;
            border-bottom: 1px solid #f0f0f0;
        }

        .setting-item:last-child {
            border-bottom: none;
        }

        .setting-info {
            flex: 1;
        }

        .setting-title {
            font-size: 16px;
            font-weight: 600;
            color: #1A4D2A;
            margin-bottom: 5px;
        }

        .setting-description {
            font-size: 13px;
            color: #666;
            line-height: 1.4;
        }

        .toggle-switch {
            position: relative;
            width: 50px;
            height: 28px;
            background: #ccc;
            border-radius: 14px;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        .toggle-switch.active {
            background: #D4AF37;
        }

        .toggle-switch::after {
            content: '';
            position: absolute;
            top: 2px;
            left: 2px;
            width: 24px;
            height: 24px;
            background: white;
            border-radius: 50%;
            transition: transform 0.3s ease;
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
        }

        .toggle-switch.active::after {
            transform: translateX(22px);
        }

        .toggle-input {
            display: none;
        }

        .btn-save {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #D4AF37, #F4D03F);
            border: none;
            border-radius: 12px;
            color: #1A4D2A;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .btn-save:hover {
            background: linear-gradient(135deg, #1A4D2A, #2d5a3d);
            color: #D4AF37;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(26, 77, 42, 0.3);
        }

        .btn-cancel {
            width: 100%;
            padding: 15px;
            background: transparent;
            border: 2px solid #D4AF37;
            border-radius: 12px;
            color: #D4AF37;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            margin-top: 10px;
        }

        .btn-cancel:hover {
            background: #D4AF37;
            color: white;
        }

        .alert {
            padding: 12px 16px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 14px;
            font-weight: 500;
        }

        .alert-error {
            background: #fee;
            color: #c53030;
            border: 1px solid #feb2b2;
        }

        .alert-success {
            background: #f0fff4;
            color: #2f855a;
            border: 1px solid #9ae6b4;
        }

        .alert i {
            font-size: 16px;
        }

        .info-box {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            font-size: 13px;
            color: #666;
            line-height: 1.5;
        }

        @media (max-width: 480px) {
            .notification-settings-content {
                padding: 20px 15px;
            }
            
            .settings-container {
                padding: 20px;
            }
            
            .setting-item {
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
            }
            
            .toggle-switch {
                align-self: flex-end;
            }
        }
    </style>
</head>
<body>
    <div class="notification-settings-container">
        <!-- Top Navigation -->
        <nav class="top-nav">
            <div class="nav-left">
                <i class="fas fa-arrow-left" onclick="goBack()"></i>
            </div>
            <div class="nav-center">
                <div class="logo">
                    <img src="images/LOGO.png" alt="2 Days Parfume Logo" class="logo-img">
                </div>
            </div>
            <div class="nav-right">
                <i class="fas fa-search" onclick="window.location.href='products.php'"></i>
            </div>
        </nav>

        <!-- Notification Settings Header -->
        <div class="notification-settings-header">
            <div class="notification-settings-title">Notification Settings</div>
            <div class="notification-settings-subtitle">Manage your notification preferences</div>
        </div>

        <!-- Notification Settings Content -->
        <div class="notification-settings-content">
            <div class="settings-container">
                <?php if ($error_message): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-circle"></i>
                        <?php echo htmlspecialchars($error_message); ?>
                    </div>
                <?php endif; ?>

                <?php if ($success_message): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i>
                        <?php echo htmlspecialchars($success_message); ?>
                    </div>
                <?php endif; ?>

                <div class="info-box">
                    <i class="fas fa-info-circle"></i>
                    Choose how you'd like to receive notifications from 2 Days Parfume. You can update these settings at any time.
                </div>

                <form method="POST" action="">
                    <!-- General Notifications -->
                    <div class="settings-section">
                        <div class="section-title">
                            <i class="fas fa-bell"></i>
                            General Notifications
                        </div>
                        
                        <div class="setting-item">
                            <div class="setting-info">
                                <div class="setting-title">Email Notifications</div>
                                <div class="setting-description">Receive important updates via email</div>
                            </div>
                            <label class="toggle-switch <?php echo $preferences['email_notifications'] ? 'active' : ''; ?>">
                                <input type="checkbox" name="email_notifications" class="toggle-input" 
                                       <?php echo $preferences['email_notifications'] ? 'checked' : ''; ?>>
                            </label>
                        </div>

                        <div class="setting-item">
                            <div class="setting-info">
                                <div class="setting-title">SMS Notifications</div>
                                <div class="setting-description">Receive text messages for urgent updates</div>
                            </div>
                            <label class="toggle-switch <?php echo $preferences['sms_notifications'] ? 'active' : ''; ?>">
                                <input type="checkbox" name="sms_notifications" class="toggle-input" 
                                       <?php echo $preferences['sms_notifications'] ? 'checked' : ''; ?>>
                            </label>
                        </div>

                        <div class="setting-item">
                            <div class="setting-info">
                                <div class="setting-title">Push Notifications</div>
                                <div class="setting-description">Receive notifications in your browser</div>
                            </div>
                            <label class="toggle-switch <?php echo $preferences['push_notifications'] ? 'active' : ''; ?>">
                                <input type="checkbox" name="push_notifications" class="toggle-input" 
                                       <?php echo $preferences['push_notifications'] ? 'checked' : ''; ?>>
                            </label>
                        </div>
                    </div>

                    <!-- Order Notifications -->
                    <div class="settings-section">
                        <div class="section-title">
                            <i class="fas fa-shopping-cart"></i>
                            Order Updates
                        </div>
                        
                        <div class="setting-item">
                            <div class="setting-info">
                                <div class="setting-title">Order Status Updates</div>
                                <div class="setting-description">Get notified when your order status changes</div>
                            </div>
                            <label class="toggle-switch <?php echo $preferences['order_updates'] ? 'active' : ''; ?>">
                                <input type="checkbox" name="order_updates" class="toggle-input" 
                                       <?php echo $preferences['order_updates'] ? 'checked' : ''; ?>>
                            </label>
                        </div>
                    </div>

                    <!-- Marketing Notifications -->
                    <div class="settings-section">
                        <div class="section-title">
                            <i class="fas fa-bullhorn"></i>
                            Marketing & Promotions
                        </div>
                        
                        <div class="setting-item">
                            <div class="setting-info">
                                <div class="setting-title">Promotional Emails</div>
                                <div class="setting-description">Receive special offers and discounts</div>
                            </div>
                            <label class="toggle-switch <?php echo $preferences['promotional_emails'] ? 'active' : ''; ?>">
                                <input type="checkbox" name="promotional_emails" class="toggle-input" 
                                       <?php echo $preferences['promotional_emails'] ? 'checked' : ''; ?>>
                            </label>
                        </div>

                        <div class="setting-item">
                            <div class="setting-info">
                                <div class="setting-title">Newsletter</div>
                                <div class="setting-description">Subscribe to our monthly newsletter</div>
                            </div>
                            <label class="toggle-switch <?php echo $preferences['newsletter'] ? 'active' : ''; ?>">
                                <input type="checkbox" name="newsletter" class="toggle-input" 
                                       <?php echo $preferences['newsletter'] ? 'checked' : ''; ?>>
                            </label>
                        </div>
                    </div>

                    <button type="submit" class="btn-save">
                        <i class="fas fa-save"></i>
                        Save Preferences
                    </button>
                </form>

                <button class="btn-cancel" onclick="goBack()">
                    <i class="fas fa-times"></i>
                    Cancel
                </button>
            </div>
        </div>

        <!-- Bottom Navigation -->
        <nav class="bottom-nav">
            <div class="nav-item" onclick="window.location.href='index.php'">
                <i class="fas fa-home"></i>
            </div>
            <div class="nav-item" onclick="window.location.href='products.php'">
                <i class="fas fa-box"></i>
            </div>
            <div class="nav-item" onclick="window.location.href='cart.php'">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <div class="nav-item" onclick="window.location.href='profile.php'">
                <i class="far fa-user"></i>
            </div>
        </nav>
    </div>

    <script>
        function goBack() {
            window.history.back();
        }

        // Toggle switch functionality
        document.addEventListener('DOMContentLoaded', function() {
            const toggleSwitches = document.querySelectorAll('.toggle-switch');
            
            toggleSwitches.forEach(toggle => {
                toggle.addEventListener('click', function() {
                    const input = this.querySelector('.toggle-input');
                    input.checked = !input.checked;
                    
                    if (input.checked) {
                        this.classList.add('active');
                    } else {
                        this.classList.remove('active');
                    }
                });
            });
        });

        // Initialize cart badge
        document.addEventListener('DOMContentLoaded', function() {
            updateCartBadge();
        });
    </script>
</body>
</html>